unit VolDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls, QExtCtrls, CustomRar;

type
  TVolDlg = class(TForm)
    Image1: TImage;
    ed: TEdit;
    canBtn: TButton;
    okBtn: TButton;
    fBtn: TButton;
    od: TOpenDialog;
    Lbl: TLabel;
    procedure fBtnClick(Sender: TObject);
    procedure edReturnPressed(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner:TComponent; vol:String);overload;
    procedure AfterConstruction;override;
  end;

var
  VolFileName:String;

implementation

{$R *.xfm}

procedure TVolDlg.fBtnClick(Sender: TObject);
begin
  if od.Execute then begin
    ed.Text:=od.FileName;
    VolFileName:=od.FileName;
  end;
end;

constructor TVolDlg.Create(AOwner:TComponent; vol:String);
begin
  inherited Create(AOwner);
  VolFileName:='';
  ed.Text:=vol;
  od.InitialDir:=ExtractFilePath(vol);
end;

procedure TVolDlg.edReturnPressed(Sender: TObject);
begin
  okBtn.SetFocus;
end;

procedure TVolDlg.AfterConstruction;
begin
  Lbl.Caption:=DLG_VOL_LABEL;
  canBtn.Caption:=DLG_CANCEL;
  okBtn.Caption:=DLG_OK;
  self.Caption:=DLG_VOL_TITLE;
end;

end.
